//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Net;
using System.Text;
using System.IO;

namespace HTMLViewer
{
	public class Quote
	{
		string symbol;
		string last;
		string change;
		string percentChange;
		string volume;
		string low;
		string high;

		public override string ToString()
		{
			return "Symbol = " + symbol + "\r\n" + "Ostatnia = " + last + "\r\n" + "Zmiana = " + change + "\r\n";
		}

		public string Last 
		{
			get {return last;}
			set {last = value;}
		}
		public string PercentChange 
		{
			get {return percentChange;}
			set {percentChange = value;}
		}
		public string Change 
		{
			get {return change;}
			set {change = value;}
		}
		public string Symbol 
		{
			get {return symbol;}
			set {symbol = value;}
		}
		public string Volume
		{
			get { return volume; }
			set { volume = value; }
		}
		public string Low 
		{
			get {return low;}
			set {low = value;}
		}
		public string High 
		{
			get {return high;}
			set {high = value;}
		}
	}
	/// <summary>
	/// Podsumowanie dla HTMLPageGet.
	/// </summary>
	public class HTMLPageGet
	{
		private HttpWebRequest request;
		private HttpWebResponse response;
		private StringBuilder strSource = new StringBuilder();
		private Quote quote = new Quote();
		public HTMLPageGet(string url, string symbol)
		{
			try
			{
				request = (HttpWebRequest)WebRequest.Create(url);
				response = (HttpWebResponse)request.GetResponse();
				// Uzyskanie strumienia danych
				StreamReader sr = new StreamReader(response.GetResponseStream(), Encoding.ASCII);
				string strTemp;
				string strSub;
				bool lastset = false;
				int pos;
				string[] tokens;
				quote.Symbol = symbol;
				while ((strTemp = sr.ReadLine()) != null)
				{
					strSource.Append(strTemp + "\r\n");					
					if(((pos = strTemp.IndexOf("Ostatni")) != -1) && !lastset)
					{
						strSub = strTemp.Substring(pos);
						tokens = strSub.Split(new char[]{';'});
						if(tokens.Length > 1)
							tokens = tokens[1].Split(new char[]{'<'});
						quote.Last = tokens[0];
					}
					if((pos = strTemp.IndexOf("Zmiana")) != -1)
					{
						strSub = strTemp.Substring(pos);
						tokens = strSub.Split(new char[]{';'});
						if(tokens.Length > 1)
						{
							if(tokens[1].StartsWith("<FONT COLOR=RED>"))
							{
								strSub = tokens[1].Substring(tokens[1].IndexOf(">") + 1);
								tokens = strSub.Split(new char[]{'<'});
							}
							else
								tokens = tokens[1].Split(new char[]{'<'});
						}
						quote.Change = tokens[0];
					}
					if((pos = strTemp.IndexOf("% Change")) != -1)
					{
						strSub = strTemp.Substring(pos);
						tokens = strSub.Split(new char[]{';'});
						if(tokens.Length > 1)
						{
							if(tokens[1].StartsWith("<FONT COLOR=RED>"))
							{
								strSub = tokens[1].Substring(tokens[1].IndexOf(">") + 1);
								tokens = strSub.Split(new char[]{'<'});
							}
							else
								tokens = tokens[1].Split(new char[]{'<'});
						}
						quote.PercentChange = tokens[0];
					}
					if((pos = strTemp.IndexOf("Najn. kurs dnia")) != -1)
					{
						strSub = strTemp.Substring(pos);
						tokens = strSub.Split(new char[]{';'});
						tokens = tokens[1].Split(new char[]{'<'});
						quote.Low = tokens[0];
					}
					if((pos = strTemp.IndexOf("Najw. kurs dnia")) != -1)
					{
						strSub = strTemp.Substring(pos);
						tokens = strSub.Split(new char[]{';'});
						tokens = tokens[1].Split(new char[]{'<'});
						quote.High = tokens[0];
					}
					if(((pos = strTemp.IndexOf("Obrt")) != -1) && !lastset)
					{
						strSub = strTemp.Substring(pos);
						tokens = strSub.Split(new char[]{';'});
						tokens = tokens[1].Split(new char[]{'<'});
						quote.Volume = tokens[0];
						lastset = true;
					}
				}
				sr.Close();
			}
			catch (WebException ex) 
			{
				strSource.Append(ex.Message);
			}			
		}
		public string Source
		{
			get
			{
				return strSource.ToString();
			}
		}
		public Quote Quote
		{
			get
			{
				return quote;
			}
		}
	}
}
